Attribute VB_Name = "MdlMain"
Option Explicit

Public Declare Sub Sleep Lib "KERNEL32.DLL" (ByVal dwMilliseconds As Long)
Public Declare Sub CopyMemory Lib "KERNEL32.DLL" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Private Sub Main()
    Dim ep As Long
    Dim lngErr As Long

    With frmMain
        .Show
        Do      ''--------------------- Main Loop
            If ExitFlag <> 0 Then Exit Sub
            If ContFlag = 1 Then
                Call ProfileStart(secStart)
                lngErr = BisInitCont(NaPID(BdId), 1)
                Do
                    Do
                        If ExitFlag <> 0 Then Exit Sub
                        Call QryStatSweCoun(NaPID(BdId), ep, totalP)
                        DoEvents
                    Loop While (ep = totalP And ContFlag = 1)
                    Call .wait_onesweep(totalP)
                    
                    If MemTrcFlag = MEM_TRC_SAVE Then Call .TraceMemoryStore
                    If intFileSave = cnt_FILE_SAVING Then Call SavingCsvFileDlg
                    
                    If ExitFlag <> 0 Then Exit Sub
                    If AborFlag = 0 Then
                        Call ProfileStop(secStart, secTiming)
                        .Text_tim.Text = Format(secTiming * 1000, "#0.00ms")
                        Call .mkr_flush(False)
                    End If
                    DoEvents
                    Call ProfileStart(secStart)
                Loop While (ContFlag)
                
                .Cmd_cont.BackColor = &H8000000F
                AborFlag = 0
            End If
            
            If SnglFlag <> 0 Then
                Call .single_sweep
            End If
            
            If MemTrcFlag = MEM_TRC_SAVE Then Call .TraceMemoryStore
            If intFileSave = cnt_FILE_SAVING Then Call SavingCsvFileDlg
            
            Sleep 1
            DoEvents
        Loop While (1)  ''------------- Main Loop
    End With
    
End Sub


Private Function stepval(ByVal code As Integer, ByVal round As Integer, ByVal lval As String, ByVal stp1 As String, _
                            ByVal stp2 As String) As String
    Dim stp As Double
    Dim ofs As Double
    Dim nval As Double   ' Always, double precision
    
    stepval = lval
    Select Case code
        Case vbKeyPageUp:   stp = CDbl(stp2)
        Case vbKeyPageDown: stp = -CDbl(stp2)
        Case vbKeyUp:       stp = CDbl(stp1)
        Case vbKeyDown:     stp = -CDbl(stp1)
        Case Else:          Exit Function
    End Select
    If round = True Then
        If (stp * lval) < 0 Then ofs = 0.9 Else ofs = 0.00001
        nval = Sgn(lval) * Fix(Abs(lval / stp) + ofs) * Abs(stp)
    Else
        nval = lval
    End If
    stepval = nval + stp
End Function

Public Sub StepVal_Int(ByVal code As Integer, ByVal round As Integer, ByRef lval As Integer, ByVal stp1 As Integer, _
                        ByVal stp2 As Integer, ByVal mn As Integer, ByVal mx As Integer)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub

Public Sub StepVal_Sng(ByVal code As Integer, ByVal round As Integer, ByRef lval As Single, ByVal stp1 As Single, _
                        ByVal stp2 As Single, ByVal mn As Single, ByVal mx As Single)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub

Public Sub StepVal_Dbl(ByVal code As Integer, ByVal round As Integer, ByRef lval As Double, ByVal stp1 As Double, _
                        ByVal stp2 As Double, ByVal mn As Double, ByVal mx As Double)
    lval = stepval(code, round, CStr(lval), CStr(stp1), CStr(stp2))
    If lval < mn Then
        lval = mn
    ElseIf lval > mx Then
        lval = mx
    End If
End Sub


Public Sub StepRbw_Sng(ByRef lval As Single)
    Dim i As Integer
    Dim rbw_tbl(31) As Single
    Dim sngTmp1 As Single
    Dim sngTmp2 As Single
    Dim mx_num As Integer

    mx_num = 22

    ' RBW table
    rbw_tbl(22) = 15000 '  15kHz
    rbw_tbl(21) = 10000 '  10kHz
    rbw_tbl(20) = 7000  '   7kHz
    rbw_tbl(19) = 5000  '   5kHz
    rbw_tbl(18) = 4000  '   4kHz
    rbw_tbl(17) = 3000  '   3kHz
    rbw_tbl(16) = 2000  '   2kHz
    rbw_tbl(15) = 1500  ' 1.5kHz
    rbw_tbl(14) = 1000  '   1kHz
    rbw_tbl(13) = 700   '  700Hz
    rbw_tbl(12) = 500   '  500Hz
    rbw_tbl(11) = 400   '  400Hz
    rbw_tbl(10) = 300   '  300Hz
    rbw_tbl(9) = 200    '  200Hz
    rbw_tbl(8) = 150    '  150Hz
    rbw_tbl(7) = 100    '  100Hz
    rbw_tbl(6) = 70     '   70Hz
    rbw_tbl(5) = 50     '   50Hz
    rbw_tbl(4) = 40     '   40Hz
    rbw_tbl(3) = 30     '   30Hz
    rbw_tbl(2) = 20     '   20Hz
    rbw_tbl(1) = 15     '   15Hz
    rbw_tbl(0) = 10     '   10Hz

    If lval < rbw_tbl(0) Then lval = rbw_tbl(0): Exit Sub
    If rbw_tbl(mx_num) < lval Then lval = rbw_tbl(mx_num): Exit Sub
    
    For i = 0 To mx_num - 1
        If rbw_tbl(i) <= lval And lval < rbw_tbl(i + 1) Then
            If rbw_tbl(i) = lval Then Exit Sub
            sngTmp1 = lval - rbw_tbl(i)
            sngTmp2 = rbw_tbl(i + 1) - lval
            If sngTmp1 < sngTmp2 Then lval = rbw_tbl(i): Exit Sub
            If sngTmp2 < sngTmp1 Then lval = rbw_tbl(i + 1): Exit Sub
        End If
    Next i

End Sub

Public Sub make_mkr_freq_list(ByRef pic As PictureBox, ByVal SngY As Single, _
                                ByRef MarkerP As structMkrInf, ByRef StrMkrList As String, ByVal col As Long)
    Dim unitVal As Double
    Dim strFmt As String

    unitVal = frmMain.get_MarkerUnit(frmMain.Combo_StimUnit(StimMKR).Text, strFmt)
    StrMkrList = StrMkrList & Format(MarkerP.MkrFreq / unitVal, strFmt) & " " & frmMain.Combo_StimUnit(StimMKR).Text
    Call PicBoxTextDisp(pic, MKR_LIST_X1, SngY, StrMkrList, col)
End Sub

Public Sub make_mkr_level_list(ByRef pic As PictureBox, ByVal SngY As Single, _
                                ByRef MarkerP As structMkrInf, ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single, _
                                ByRef StrMkrList As String, ByVal col As Long)
    Dim tmp(5) As String
        
    If frmMain.SSTab_DispFromat.Tab = FmtTypeOverlap Then   ' Overlap Display
        If frmMain.Check_Format(frmMain.Combo_MkrActFormat.ListIndex).Value = 1 Then
            Call select_format_display(MarkerP, frmMain.Combo_MkrActFormat.ListIndex, Data1(), Data2(), Data3(), tmp())
        End If
    Else
        Call select_format_display(MarkerP, frmMain.SSTab_DispFromat.Tab, Data1(), Data2(), Data3(), tmp())
    End If
    
    Call PicBoxTextDisp(pic, MKR_LIST_X2, SngY, tmp(2), col)
    Call PicBoxTextDisp(pic, MKR_LIST_X3, SngY, tmp(3), col)
    Call PicBoxTextDisp(pic, MKR_LIST_X4, SngY, tmp(4), col)

End Sub

Public Sub make_mkr_list(ByRef pic As PictureBox, ByVal SngY As Single, ByRef MarkerP As structMkrInf, _
                            ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single, ByRef StrMkrList As String, ByVal col As Long)
        
    Call make_mkr_freq_list(pic, SngY, MarkerP, StrMkrList, col)
    Call make_mkr_level_list(pic, SngY, MarkerP, Data1(), Data2(), Data3(), StrMkrList, col)
    
End Sub

Public Sub x_mkr_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                            ByRef scl As Scale_t, ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single, _
                            ByRef chk() As Integer, ByRef mx_mn() As structMkrInf, ByVal list_disp As Integer)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin, dt As Single
    Dim DeltY As Single
    Dim xx As Single
    Dim yy As Single
    Dim k As Integer
    Dim StrMkrFreqData As String
    Dim StrMeasData As String
    Dim Y_line As Single
    Dim mp As Integer
    Dim mkr_frq As Double
    Dim mkr(MEAS_NUM) As String
    
    mkr(MEAS_MAX_ID) = "Mx"
    mkr(MEAS_MIN_ID) = "Mn"
    mkr(MEAS_0DG_ID) = "Dg"
    
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)

    'Calculating 
    With GrphRect
        ss = Gsmax - Gsmin
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        '
        Y_line = 170    ' 1 Line Offset
        
        For k = 0 To MEAS_NUM - 1
            If chk(k) Then
                StrMkrFreqData = ""
                StrMeasData = ""
                mp = mx_mn(k).MkrPoint
                mkr_frq = mx_mn(k).MkrFreq
                If k = MEAS_0DG_ID Then
                    If chk(k) = 2 Then
                        dt = Data2(mp)
                    Else
                        dt = Data1(mp)
                    End If
                    If BufFrq(mp) = mkr_frq Then
                        xx = .DeltX * mp + .ViewX
                        yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                    Else
                        If chk(k) = 2 Then
                            Call Get_X_Y_Interpolation(mp, mkr_frq, dt, BufFrq(), Data2())
                        Else
                        Call Get_X_Y_Interpolation(mp, mkr_frq, dt, BufFrq(), Data1())
                        End If
                        xx = .DeltX * mkr_frq + .ViewX
                        yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                    End If
                Else
                    dt = Data1(mp)
                    xx = .DeltX * mp + .ViewX
                    yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                End If
                
                pic.PSet (xx, yy)
                pic.Line (xx, yy)-(xx, yy - 200), MkrClrList(MKR_L_COLOR_ACT)
                pic.Line (xx, yy)-(xx - 40, yy - 100), MkrClrList(MKR_L_COLOR_ACT)
                pic.Line (xx, yy)-(xx + 40, yy - 100), MkrClrList(MKR_L_COLOR_ACT)
                Call PicBoxTextDisp(pic, xx - 50, yy - 380, mkr(k), MkrClrList(MKR_L_COLOR_ACT)) 'Marker No. display
                
                StrMkrFreqData = mkr(k) & vbTab '", Freq :"
                Call make_mkr_freq_list(pic, Y_line * k, mx_mn(k), StrMkrFreqData, MkrClrList(MKR_L_COLOR_ACT))
                If list_disp Then
                    Call make_mkr_level_list(pic, Y_line * k, mx_mn(k), Data1(), Data2(), Data3(), StrMeasData, MkrClrList(MKR_L_COLOR_ACT))
                End If
            End If
        Next k
    End With
End Sub

Public Sub select_format_display(ByRef MrkP As structMkrInf, ByVal fmt_type As Integer, _
                            ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single, _
                            ByRef Meas_Data_List() As String)
    Dim mkrf As Double
    Dim R As Single
    Dim X As Single
    Dim res As Double
    Dim swr As Single
    Dim unitVal As Double
    Dim strFmt As String
    Dim f As Double
    Dim re As Single
    Dim im As Single
    Dim Lvl As Single
    Dim mp As Integer
    Dim lngErr As Long

    mkrf = MrkP.MkrFreq
    mp = MrkP.MkrPoint

    If fmt_type = FmtTypeSmith Then
        f = mkrf
        re = Data1(mp)
        im = Data2(mp)
        Lvl = Data3(mp)
        If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
            Call Get_X_Y_Interpolation(mp, f, re, BufFrq(), Data1())
            f = mkrf: Call Get_X_Y_Interpolation(mp, f, im, BufFrq(), Data2())
            f = mkrf: Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data3())
        End If
        Call frmMain.get_r_reactance(re, im, R, X)
        Meas_Data_List(2) = Format(R, "#0.000")
        Meas_Data_List(3) = Format(X, "#0.000")
        Meas_Data_List(4) = Format(Lvl, "#0.0000")
    Else
            ' *** Logmag & PHASE or POLAR or DELAY ***
        f = mkrf
        If fmt_type = FmtTypeDelay Then ' DELAY
            Lvl = Data1(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data1())
            End If
            Meas_Data_List(2) = frmMain.chg_value(Lvl)
        Else
            Lvl = Data1(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data1())
            End If
            Meas_Data_List(2) = Format(Lvl, "#0.000") & " dB"
        End If
        If frmMain.Check_phs.Value = 1 Then
            f = mkrf
            Lvl = Data2(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data2())
            End If
            Meas_Data_List(3) = Format(Lvl, "#0.000") & " deg"
        Else
            Meas_Data_List(3) = " "
        End If
        If fmt_type = FmtTypeSwr Then
            f = mkrf
            Lvl = Data3(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data3())
            End If
            If Lvl = 1 Then
                swr = 10000000000000#   'Error Data
            Else
                swr = Abs((1 + Lvl) / (1 - Lvl))
            End If
            Meas_Data_List(4) = Format(swr, "#0.0000")
        ElseIf fmt_type = FmtTypeReal Then
            f = mkrf
            Lvl = Data3(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data3())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        ElseIf fmt_type = FmtTypeImag Then
            f = mkrf
            Lvl = Data3(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data3())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        Else
            f = mkrf
            Lvl = Data3(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), Data3())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        End If
    End If

End Sub


Public Sub select_format_display2(ByRef MrkP As structMkrInf, ByVal fmt_type As Integer, ByRef Meas_Data_List() As String)
    Dim mkrf As Double
    Dim R As Single
    Dim X As Single
    Dim res As Double
    Dim swr As Single
    Dim unitVal As Double
    Dim strFmt As String
    Dim f As Double
    Dim re As Single
    Dim im As Single
    Dim Lvl As Single
    Dim mp As Integer
    Dim lngErr As Long

    mkrf = MrkP.MkrFreq
    mp = MrkP.MkrPoint

    If fmt_type = FmtTypeSmith Then
        f = mkrf
        re = BufReal(mp)
        im = BufImag(mp)
        Lvl = BufLnm(mp)
        If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
            Call Get_X_Y_Interpolation(mp, f, re, BufFrq(), BufReal())
            f = mkrf: Call Get_X_Y_Interpolation(mp, f, im, BufFrq(), BufImag())
            f = mkrf: Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufLnm())
        End If
        Call frmMain.get_r_reactance(re, im, R, X)
        Meas_Data_List(2) = Format(R, "#0.000")
        Meas_Data_List(3) = Format(X, "#0.000")
        Meas_Data_List(4) = Format(Lvl, "#0.0000")
    Else
            ' *** Logmag & PHASE or POLAR or DELAY ***
        f = mkrf
        If fmt_type = FmtTypeDelay Then ' DELAY
            Lvl = BufDelay(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufDelay())
            End If
            Meas_Data_List(2) = frmMain.chg_value(Lvl)
        Else
            Lvl = BufLgm(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufLgm())
            End If
            Meas_Data_List(2) = Format(Lvl, "#0.000 dB")
        End If
        If frmMain.Check_phs.Value = 1 Then
            f = mkrf
            Lvl = BufPhs(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufPhs())
            End If
            Meas_Data_List(3) = Format(Lvl, "#0.000 deg")
        Else
            Meas_Data_List(3) = " "
        End If
        If fmt_type = FmtTypeSwr Then
            f = mkrf
            Lvl = BufLnm(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufLnm())
            End If
            If Lvl = 1 Then
                swr = 10000000000000#   'Error Data
            Else
                swr = Abs((1 + Lvl) / (1 - Lvl))
            End If
            Meas_Data_List(4) = Format(swr, "#0.0000")
        ElseIf fmt_type = FmtTypeReal Then
            f = mkrf
            Lvl = BufReal(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufReal())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        ElseIf fmt_type = FmtTypeImag Then
            f = mkrf
            Lvl = BufImag(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufImag())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        Else
            f = mkrf
            Lvl = BufLnm(mp)
            If Marker(BdId, ActCh(BdId), ActMkr).MkrReference = MKR_REF_FREQ Then
                Call Get_X_Y_Interpolation(mp, f, Lvl, BufFrq(), BufLnm())
            End If
            Meas_Data_List(4) = Format(Lvl, "#0.0000")
        End If
    End If

End Sub

Public Sub Arw_trk_mkr_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_Circle_coordinate, _
                                ByRef list_disp As Integer, ByRef re() As Single, ByRef im() As Single, ByRef Data() As Single)
    Dim maxp As Long
    Dim minp As Long
    Dim meas_format As Integer
    Dim max_min(MEAS_NUM) As structMkrInf
    Dim chkbx(MEAS_NUM) As Integer
    Dim mkr_list As Integer
    
    With frmMain.SSTab_DispFromat
        If .Tab = FmtTypeOverlap Then
            If frmMain.Check_Format(ChkTypeLogMg).Value = 1 Then
                meas_format = FmtTypeLogMg
            ElseIf frmMain.Check_Format(ChkTypeDelay).Value = 1 Then
                meas_format = FmtTypeDelay
            ElseIf frmMain.Check_Format(ChkTypeSwr).Value = 1 Then
                meas_format = FmtTypeSwr
            ElseIf frmMain.Check_Format(ChkTypeReal).Value = 1 Then
                meas_format = FmtTypeReal
            ElseIf frmMain.Check_Format(ChkTypeImag).Value = 1 Then
                meas_format = FmtTypeImag
            End If
            If list_disp = MKR_LIST_OFF Then
                mkr_list = frmMain.Check_Format(frmMain.Combo_MkrActFormat.ListIndex).Value
            Else
                mkr_list = MKR_LIST_OFF
            End If
        Else
            meas_format = .Tab
            If list_disp = MKR_LIST_OFF Then
                mkr_list = MKR_LIST__ON
            Else
                mkr_list = MKR_LIST_OFF
            End If
        End If
    End With

    If frmMain.Check_Tracking(MEAS_MAX_ID).Value = 1 Then   'Max Search
        max_min(MEAS_MAX_ID).MkrPoint = lngSearchData(MEAS_MAX_ID, meas_format, max_min(MEAS_MAX_ID).MkrFreq)
        chkbx(MEAS_MAX_ID) = 1
    End If
    
    If frmMain.Check_Tracking(MEAS_MIN_ID).Value = 1 Then   'Min Search
        max_min(MEAS_MIN_ID).MkrPoint = lngSearchData(MEAS_MIN_ID, meas_format, max_min(MEAS_MIN_ID).MkrFreq)
        chkbx(MEAS_MIN_ID) = 1
    End If
    
    If frmMain.Check_Tracking(MEAS_0DG_ID).Value = 1 Then   '0 Deg Search
        max_min(MEAS_0DG_ID).MkrPoint = lngSearchData(MEAS_0DG_ID, meas_format, max_min(MEAS_0DG_ID).MkrFreq)
        chkbx(MEAS_0DG_ID) = 1
    End If
        
    If chkbx(MEAS_MAX_ID) = 0 And chkbx(MEAS_MIN_ID) = 0 And chkbx(MEAS_0DG_ID) = 0 Then Exit Sub
    
    If max_min(MEAS_MAX_ID).MkrPoint < 0 Then max_min(MEAS_MAX_ID).MkrPoint = 0: max_min(MEAS_MAX_ID).MkrFreq = BufFrq(0)
    If max_min(MEAS_MIN_ID).MkrPoint < 0 Then max_min(MEAS_MIN_ID).MkrPoint = 0: max_min(MEAS_MIN_ID).MkrFreq = BufFrq(0)
    If max_min(MEAS_0DG_ID).MkrPoint < 0 Then max_min(MEAS_0DG_ID).MkrPoint = 0: max_min(MEAS_0DG_ID).MkrFreq = BufFrq(0)
    With GrphCircle
        Call Arw_x_mkr_display(pic, GrphCircle, re, im, Data, chkbx(), max_min(), mkr_list)
    End With
    
    If list_disp = MKR_LIST_OFF Then list_disp = mkr_list
End Sub

Public Sub Arw_x_mkr_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_Circle_coordinate, _
                    ByRef re() As Single, ByRef im() As Single, ByRef Data() As Single, _
                    ByRef chk() As Integer, ByRef mx_mn() As structMkrInf, ByVal list_disp As Integer)
    Dim xx As Single
    Dim yy As Single
    Dim StrMeasData As String
    Dim k As Integer
    Dim Y_line As Single
    Dim mp As Integer
    Dim mkr_frq As Double
    Dim mkr(MEAS_NUM) As String
    
    mkr(MEAS_MAX_ID) = "Mx"
    mkr(MEAS_MIN_ID) = "Mn"
    mkr(MEAS_0DG_ID) = "Dg"
    '
    Y_line = 170    ' 1 Line Offset
    
    With GrphCircle
        For k = 0 To MEAS_NUM - 1
            If chk(k) = 1 Then
                mp = mx_mn(k).MkrPoint
                mkr_frq = mx_mn(k).MkrFreq
                
                If BufFrq(mp) = mkr_frq Then
                    xx = SclLimP(.CenX, .HanX, re(mp))
                    yy = SclLimP(.CenY, -.HanY, im(mp))
                Else
                    If mp <> 0 Then
                        If BufFrq(mp - 1) < mkr_frq And mkr_frq < BufFrq(mp) Then
                            mp = mp - 1
                        ElseIf BufFrq(mp) < mkr_frq And mkr_frq < BufFrq(mp - 1) Then
                            mp = mp - 1
                        End If
                    End If
                    If BufFrq(mp + 1) = BufFrq(mp) Then
                        yy = im(mp) + (im(mp + 1) - im(mp))
                        xx = re(mp) + (re(mp + 1) - re(mp))
                    Else
                        yy = im(mp) + (mkr_frq - BufFrq(mp)) * ((im(mp + 1) - im(mp)) / (BufFrq(mp + 1) - BufFrq(mp)))
                        xx = re(mp) + (mkr_frq - BufFrq(mp)) * (re(mp + 1) - re(mp)) / (BufFrq(mp + 1) - BufFrq(mp))
                    End If
                    xx = SclLimP(.CenX, .HanX, xx)
                    yy = SclLimP(.CenY, -.HanY, yy)
                End If
                pic.Line (xx, yy)-(xx, yy - 200), MkrClrList(MKR_L_COLOR_ACT)
                pic.Line (xx, yy)-(xx - 40, yy - 100), MkrClrList(MKR_L_COLOR_ACT)
                pic.Line (xx, yy)-(xx + 40, yy - 100), MkrClrList(MKR_L_COLOR_ACT)
                Call PicBoxTextDisp(pic, xx - 50, yy - 380, mkr(k), MkrClrList(MKR_L_COLOR_ACT)) 'Marker No. display
                
                StrMeasData = mkr(k) & vbTab '", Freq :"
                Call make_mkr_freq_list(pic, Y_line * k, mx_mn(k), StrMeasData, MkrClrList(MKR_L_COLOR_ACT))
                If list_disp Then
                    Call make_mkr_level_list(pic, Y_line * k, mx_mn(k), re(), im(), Data(), StrMeasData, MkrClrList(MKR_L_COLOR_ACT))
                End If
            End If
        Next k
    End With
End Sub

Public Sub ExpSwBoxType(ByRef swbox_typ As Long, ByRef str As String, ByVal get_type As Integer)

    If get_type = McrGetName Then
        If swbox_typ = SWBOX_NONC Then
            str = SWBOX_TYPE_NONC
        ElseIf swbox_typ = SWBOX_DPDT Then
            str = SWBOX_TYPE_DPDT
        ElseIf swbox_typ = SWBOX_SP4T Then
            str = SWBOX_TYPE_SP4T
        Else
            str = SWBOX_TYPE_NONC
        End If
    Else
        If str = SWBOX_TYPE_NONC Then
            swbox_typ = SWBOX_NONC
        ElseIf str = SWBOX_TYPE_DPDT Then
            swbox_typ = SWBOX_DPDT
        ElseIf str = SWBOX_TYPE_SP4T Then
            swbox_typ = SWBOX_SP4T
        Else
            swbox_typ = SWBOX_NONC
        End If
    End If

End Sub

